/*****************************************************************************
*  LPC8xx Center aligned demo program for LPCXpresso board
*
*  1. Use SCT timer to generate a PWM output signal @ SCT_OUT0
*  2. Every time P0_0 goes high to low increase the duty cycle.
*  3. Every time P0_0 goes high to low decrease the duty cycle.
*  4. SCT_OUT0 is connected to P0_16 (blue LED).
*****************************************************************************/

#include "board.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/
void SCT_Init(void);
/*****************************************************************************
 * Public functions
 ****************************************************************************/
void SCT_Init(void)
{

	Chip_SCT_Init(LPC_SCT);			                   					// enable the SCT3 clock

	Chip_SCT_Config(LPC_SCT, SCT_CONFIG_16BIT_COUNTER	|	 				// two 16-bit timers
                           SCT_CONFIG_AUTOLIMIT_L	);					// auto limit

	Chip_SCT_SetControl(LPC_SCT, SCT_CTRL_BIDIR_L(1)	|
                               SCT_CTRL_PRE_L(5)		);			  // Bidir mode, prescaler = 6, SCT clock = 2 MHz

	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_0,	9);						// match 0 @ 10/2MHz = 5 usec (100 KHz PWM freq)
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, 9);

	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_1,	5);						// match 1 used for duty cycle (in 10 steps)
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_1, 5);


	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_0, ENABLE_ALL_STATES);			// event 0 happens in all states
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH1 |
                                                                        SCT_COMBMODE_MATCH	));		// match 1 condition only

	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_0, SCT_EVT_0 );				// event 0 will clear SCT_OUT0

	Chip_SCT_SetoutputdirControl(LPC_SCT, SCT_EVT_0);						// reverse output 0 set when down counting



    Chip_SCT_ClearControl(LPC_SCT, SCT_CTRL_HALT_L);						// start timer
}


int main(void)
{

  	SystemCoreClockUpdate();
  	Board_Init();


  	Chip_Clock_EnablePeriphClock( SYSCTL_CLOCK_SWM);					//enable SWM clock
        
    Chip_SWM_DisableFixedPin(SWM_FIXED_ACMP_I1);                                           //disable Pinmux for P0_0 (ACMP_I1)
       
  	Chip_SWM_MovablePinAssign(SWM_CTOUT_0_O , 16);					      // P0_16 is SCT_OUT0

    SCT_Init();                                           					// Initialize SCT

    while (1)                                              					// loop forever
    {
      if (Chip_GPIO_GetPinState(LPC_GPIO_PORT, 0,0)  & 0x01) 			/* PIO0 high or low?       */
      {
        if (LPC_SCT->MATCHREL[1].L < 9)
            LPC_SCT->MATCHREL[1].L ++;          					/* increase PWM duty cycle */
      }
      else
      {
        if (LPC_SCT->MATCHREL[1].L > 0)
            LPC_SCT->MATCHREL[1].L --;          					/* decrease PWM duty cycle */
      }
	
    }
}
